#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Apollonian ZoomMod01.fsh  by mla 
//https://www.shadertoy.com/view/Wt3XR8
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

////////////////////////////////////////////////////////////////////////////////
//
// Apollonian circles. Iterated inversion in a ring of circles.
//
////////////////////////////////////////////////////////////////////////////////

const float N = 5.0; // Number of circles
const int max_iterations = 40;
const float pi = 3.14159265;

// Circles are represented as vec3(x,y,r2) where
// (x,y) is the centre and r2 is the squared radius.

// Invert pos in circle c
vec2 invert(vec2 pos, vec3 c) {
  vec2 p = pos-c.xy;
  float p2 = dot(p,p);
  return p*c.z/p2 + c.xy;
}
  
// Invert pos in circle if it is inside 
bool checkinverse(inout vec2 pos, vec3 c, inout float r2min) {
  vec2 p = pos-c.xy; 
  float p2 = dot(p,p);
  r2min = min(r2min,abs(p2-c.z));
  if (p2 > c.z) {
    return false;
  } else {
    pos = p*c.z/p2 + c.xy;
    return true;
  }
}

bool checkinverse2(inout vec2 pos, vec3 c, inout float r2min) {
  vec2 p = pos-c.xy; 
  float p2 = dot(p,p);
  r2min = min(r2min,abs(p2-c.z));
  if (p2 < c.z) {
    return false;
  } else {
    pos = p*c.z/p2 + c.xy;
    return true;
  }
}

// N circles in a ring, with tangency points on unit circle,
// plus a central circle, tangent to the others, plus an
// surrounding circle, tangent to the ring circles.
// The radius of the ring circles can vary so as to overlap
// or to leave a gap.
vec4 gasket(vec2 pos, bool varyradius){
  float theta = pi/N;
  float r = 1.0/cos(theta);
  float s = tan(theta);
  float r2min = 1e10;
  float t = -0.2*iTime;
  float rfactor = !varyradius?1.0:0.95 + 0.26*(1.0+cos(0.5*iTime));
  for(int n = 0; n < max_iterations; n++){
    vec3 c = vec3(0,0,pow(r-s,2.0));
    // Try inverting in central circle
    if (!checkinverse(pos,c,r2min) &&
        !checkinverse2(pos,vec3(0.0,0.0,pow(r+s,2.0)),r2min)) {
      bool found = false;
      // else try in the circles of the ring.
      for (float i = 0.0; i < N; i++) {
        vec3 c = vec3(r*sin(2.0*i*theta+t),
                      r*cos(2.0*i*theta+t),
                      rfactor*s*s);
        if (checkinverse(pos,c,r2min)) {
          found = true;
          break;
        }
      }
      if (!found) return vec4(pos,n,r2min);
    }
  }
  return vec4(pos,max_iterations,r2min);
}

// Smooth HSV to RGB conversion 
// Function by iq, from https://www.shadertoy.com/view/MsS3Wc
vec3 hsv2rgb( in vec3 c ) {
  vec3 rgb = clamp( abs(mod(c.x*6.0+vec3(0.0,4.0,2.0),6.0)-3.0)-1.0, 0.0, 1.0 );
  rgb = rgb*rgb*(3.0-2.0*rgb); // cubic smoothing	
  return c.z * mix( vec3(1.0), rgb, c.y);
}

vec3 getCol(vec4 n){
  vec3 col = hsv2rgb(vec3(mod(n.z/20.0,1.0),0.8,0.8));
  col *= 0.6+0.4*smoothstep(0.05,0.1,sqrt(n.w));
  return col;
}

bool keypress(int code) {
  return texelFetch(iChannel0, ivec2(code,2),0).x != 0.0;
}

const int CHAR_A = 65;
const int CHAR_D = 68;
const int CHAR_H = 72;
const int CHAR_J = 74;
const int CHAR_V = 86;
const int CHAR_Z = 90;

vec2 cmul(vec2 z, vec2 w) {
  return vec2(z.x*w.x - z.y*w.y, z.x*w.y + z.y*w.x);
}

vec2 cinv(vec2 z) {
  return z/dot(z,z)*vec2(1,-1);
}

vec2 csqrt(vec2 z) {
  float r = length(z);
  return vec2(sqrt(0.5*(r+z.x)),sign(z.y)*sqrt(0.5*(r-z.x)));
}

#define AA 2.0

//void mainImage( out vec4 fragColor, in vec2 fragCoord ){
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
 fragColor.xyz = vec3(0);
  vec2 z0 = 2.0 * fragCoord.xy / iResolution.y - vec2(iResolution.x / iResolution.y, 1.0);
  float zoom = 1.0; 
  if (!keypress(CHAR_Z)) zoom = exp(45.0-mod(0.4*iTime,60.0));
  for (float i = 0.0; i < AA; i++) {
    for (float j = 0.0; j < AA; j++) {
      float delta = 1.0/(AA*iResolution.y);
      vec2 z = z0 + delta*vec2(i,j);
      z *= zoom;
      if (keypress(CHAR_H)) {
        z.y += 1.0;
        z = invert(z,vec3(0,-1,2)); // Map half plane to unit disk.
      }
      if (keypress(CHAR_D)) {
        z = invert(z,vec3(0,0,1)); // Invert in unit disk
      }
      if (!keypress(CHAR_A) && iMouse.x != 0.0) {
        vec2 m = 2.0 * iMouse.xy / iResolution.y - vec2(iResolution.x / iResolution.y, 1.0);
        //m = 1.2*vec2(cos(0.0789*iTime),sin(0.0789*iTime));
        m *= zoom;
        // Map origin to m with an inversion
        vec2 c = m/dot(m,m); // m inverted in unit circle
        z = invert(z,vec3(c,dot(c,c)-1.0));
      }
      bool varyradius = !keypress(CHAR_V);
      vec4 data = gasket(z,varyradius);
             
      fragColor.xyz += getCol(data);
    }
  }
  fragColor.xyz /= AA*AA;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

